@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      checkcs.bat
REM
REM  Contents:  A batch file which checks for the existance of a Trusted Root
REM		certificate authority and creates one if necessary. 
REM		Afterwards, it creates both remote and local Intel(R) AMT client 
REM 		certificates signed with the trusted root certificate previously 
REM		generated.
REM
REM ----------------------------------------------------------------------------


REM ######################################################################
REM ###                                                                ###
REM ### This batch is called by the Configuration Server program       ###
REM ### in order to check if the trusted root CA is ready for use.     ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ###                                                                ###
REM ######################################################################

REM ----------------------------------------------------------------------
REM The following environment parameters can be customized.
REM Note that they may the supplied default.conf.xml files.
REM ----------------------------------------------------------------------
set TRUSTED_ROOT_CRL_DISTRIBUTION_POINT=URI:http://trusted_root_crls.com
set REMOTE_CLIENT_CN=management_console.intel.com
set LOCAL_CLIENT_CN=acme_app.intel.com
set PKCS12_PASSWORD=qwerty
REM ----------------------------------------------------------------------
set exitCode=0

set PATH=%PATH%;../openSSL

IF NOT EXIST "trusted_rootCA" goto create
IF NOT EXIST "remote_client" goto create
IF NOT EXIST "local_client" goto create

echo Check Trusted-Root passed

goto end

:create
echo Configuration server needs a Trusted Root CA certificate in order
echo to be able to set up Intel(R) AMT devices for TLS client authentication.
echo You can create demo trusted root CA and have it sign demo remote 
echo and local client certificates.
echo The certificates generated in this script should ONLY be used for testing
echo and demonstrational purposes !
set exitCode=2
yesno "Create a demo Trusted Root CA and use it to sign client certificates [Y/n] ?" Y
IF NOT errorlevel 1 goto end
set exitCode=0

set CALLER_WAITS_ON_EXIT=1
call start /WAIT trusted_rootCA_gen.bat
call start /WAIT remote_client_req.bat
call start /WAIT remote_client_sign.bat
call start /WAIT remote_client_export.bat
call start /WAIT local_client_req.bat
call start /WAIT local_client_sign.bat
call start /WAIT local_client_export.bat

:end
:exit %exitCode%